/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWTime;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskField;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskMacros;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class VWWFDeadlinePanel
extends JPanel
implements ActionListener,
DocumentListener {
    private VWMaskMacros m_macros = null;
    private VWMaskField m_deadlineTextField = null;
    private JComboBox m_deadlineUnitCBox = null;
    private VWMaskField m_reminderTextField = null;
    private JComboBox m_reminderUnitCBox = null;
    private VWWorkflowDefinition m_workflowDefinition = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWLabelListCellRenderer m_customComboBoxRenderer = new VWLabelListCellRenderer();

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_deadlineUnitCBox) {
            this.updateDeadlineDefinition();
        } else if (event.getSource() == this.m_reminderUnitCBox) {
            this.updateReminderDefinition();
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        if (event.getDocument() == this.m_deadlineTextField.getDocument()) {
            this.updateDeadlineDefinition();
        } else if (event.getDocument() == this.m_reminderTextField.getDocument()) {
            this.updateReminderDefinition();
        }
    }

    public void removeUpdate(DocumentEvent event) {
        if (event.getDocument() == this.m_deadlineTextField.getDocument()) {
            this.updateDeadlineDefinition();
        } else if (event.getDocument() == this.m_reminderTextField.getDocument()) {
            this.updateReminderDefinition();
        }
    }

    protected void init(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_macros = new VWMaskMacros();
            this.m_macros.addMacro('#', "[0-9]");
            this.createControls();
            this.reinitialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        long deadline = 0L;
        long reminder = 0L;
        try {
            this.enableControls(false);
            if (this.m_authPropertyData != null) {
                this.m_workflowDefinition = this.m_authPropertyData.getWorkflowDefinition();
                if (this.m_workflowDefinition != null) {
                    deadline = this.m_workflowDefinition.getDeadline();
                    reminder = this.m_workflowDefinition.getReminder();
                    this.enableControls(true);
                }
            }
            this.updateControls(deadline, reminder);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void releaseReferences() {
        if (this.m_deadlineTextField != null) {
            this.m_deadlineTextField.getDocument().removeDocumentListener(this);
            this.m_deadlineTextField = null;
        }
        if (this.m_deadlineUnitCBox != null) {
            this.m_deadlineUnitCBox.removeActionListener(this);
            this.m_deadlineUnitCBox = null;
        }
        if (this.m_reminderTextField != null) {
            this.m_reminderTextField.getDocument().removeDocumentListener(this);
            this.m_reminderTextField = null;
        }
        if (this.m_reminderUnitCBox != null) {
            this.m_reminderUnitCBox.removeActionListener(this);
            this.m_reminderUnitCBox = null;
        }
        this.m_macros = null;
        this.m_workflowDefinition = null;
        this.m_authPropertyData = null;
    }

    private void createControls() {
        try {
            this.setLayout(new BorderLayout());
            VWToolbarBorder deadlineBorder = new VWToolbarBorder(VWResource.s_deadlineStr, 0x40000000);
            this.add((Component)deadlineBorder, "First");
            JPanel clientPanel = deadlineBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 5, 2, 6);
            clientPanel.add((Component)new JLabel(VWResource.s_deadlineWithin), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.1;
            this.m_deadlineTextField = new VWMaskField("#####", this.m_macros, ' ');
            this.m_deadlineTextField.setName("m_deadlineTextField_VWWFDeadlinePanel");
            this.m_deadlineTextField.setText("0");
            this.m_deadlineTextField.setColumns(3);
            this.m_deadlineTextField.getDocument().addDocumentListener(this);
            clientPanel.add((Component)this.m_deadlineTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(2, 0, 2, 0);
            this.m_deadlineUnitCBox = new JComboBox();
            this.m_deadlineUnitCBox.setName("m_deadlineUnitCBox_VWWFDeadlinePanel");
            this.m_deadlineUnitCBox.addItem(VWResource.s_minutes);
            this.m_deadlineUnitCBox.addItem(VWResource.s_hours);
            this.m_deadlineUnitCBox.addItem(VWResource.s_days);
            this.m_deadlineUnitCBox.addItem(VWResource.s_weeks);
            this.m_deadlineUnitCBox.setRenderer(this.m_customComboBoxRenderer);
            this.m_deadlineUnitCBox.addActionListener(this);
            clientPanel.add((Component)this.m_deadlineUnitCBox, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.insets = new Insets(2, 5, 2, 6);
            clientPanel.add((Component)new JLabel(VWResource.s_sendReminderBeforeDeadline), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.1;
            this.m_reminderTextField = new VWMaskField("#####", this.m_macros, ' ');
            this.m_reminderTextField.setName("m_reminderTextField_VWWFDeadlinePanel");
            this.m_reminderTextField.setText("0");
            this.m_reminderTextField.setColumns(3);
            this.m_reminderTextField.getDocument().addDocumentListener(this);
            clientPanel.add((Component)this.m_reminderTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(2, 0, 2, 0);
            this.m_reminderUnitCBox = new JComboBox();
            this.m_reminderUnitCBox.setName("m_reminderUnitCBox_VWWFDeadlinePanel");
            this.m_reminderUnitCBox.addItem(VWResource.s_minutes);
            this.m_reminderUnitCBox.addItem(VWResource.s_hours);
            this.m_reminderUnitCBox.addItem(VWResource.s_days);
            this.m_reminderUnitCBox.addItem(VWResource.s_weeks);
            this.m_reminderUnitCBox.setRenderer(this.m_customComboBoxRenderer);
            this.m_reminderUnitCBox.addActionListener(this);
            clientPanel.add((Component)this.m_reminderUnitCBox, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void enableControls(boolean bEnable) {
        try {
            this.m_deadlineUnitCBox.setEnabled(bEnable);
            this.m_deadlineTextField.setEnabled(bEnable);
            this.m_reminderTextField.setEnabled(bEnable);
            this.m_reminderUnitCBox.setEnabled(bEnable);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateControls(long deadline, long reminder) {
        try {
            VWTime deadlineTime = new VWTime(deadline, 0);
            VWTime reminderTime = new VWTime(reminder, 0);
            if (deadline != 0L) {
                if (!(deadlineTime.convertTime(3) || deadlineTime.convertTime(2) || deadlineTime.convertTime(1))) {
                    deadlineTime.convertTime(0);
                }
            } else {
                deadlineTime.convertTime(0);
            }
            this.m_deadlineTextField.getDocument().removeDocumentListener(this);
            this.m_deadlineUnitCBox.removeActionListener(this);
            this.m_deadlineTextField.setText(deadlineTime.getTime() + "");
            this.m_deadlineUnitCBox.setSelectedIndex(deadlineTime.getUnit());
            this.m_deadlineTextField.getDocument().addDocumentListener(this);
            this.m_deadlineUnitCBox.addActionListener(this);
            if (reminder != 0L) {
                if (!(reminderTime.convertTime(3) || reminderTime.convertTime(2) || reminderTime.convertTime(1))) {
                    reminderTime.convertTime(0);
                }
            } else {
                reminderTime.convertTime(0);
            }
            this.m_reminderTextField.getDocument().removeDocumentListener(this);
            this.m_reminderUnitCBox.removeActionListener(this);
            this.m_reminderTextField.setText(reminderTime.getTime() + "");
            this.m_reminderUnitCBox.setSelectedIndex(reminderTime.getUnit());
            this.m_reminderTextField.getDocument().addDocumentListener(this);
            this.m_reminderUnitCBox.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateDeadlineDefinition() {
        try {
            String deadlineString = this.m_deadlineTextField.getText();
            if (deadlineString.length() == 0) {
                deadlineString = "0";
            }
            Long deadline = new Long(deadlineString.trim());
            int deadlineUnit = this.m_deadlineUnitCBox.getSelectedIndex();
            VWTime timeDeadline = new VWTime(deadline, deadlineUnit);
            timeDeadline.convertTime(0);
            this.m_workflowDefinition.setDeadline(timeDeadline.getTime());
            this.m_authPropertyData.setDirty();
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateReminderDefinition() {
        try {
            String reminderString = this.m_reminderTextField.getText();
            if (reminderString.length() == 0) {
                reminderString = "0";
            }
            Long reminder = new Long(reminderString.trim());
            int reminderUnit = this.m_reminderUnitCBox.getSelectedIndex();
            VWTime timeReminder = new VWTime(reminder, reminderUnit);
            timeReminder.convertTime(0);
            this.m_workflowDefinition.setReminder(timeReminder.getTime());
            this.m_authPropertyData.setDirty();
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

